package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsUnactivate.java 1026 2013-08-27 07:52:36Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class GrowingSystemsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 5109566144227877080L;

    protected GrowingSystemService growingSystemService;

    protected List<String> growingSystemIds;

    protected boolean activate;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "growing-systems-list" }) })
    public String execute() throws Exception {
        growingSystemService.unactivateGrowingSystems(growingSystemIds, activate);
        return SUCCESS;
    }
}
