package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ValidateGrowingPlan.java 2425 2013-12-10 17:33:11Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/ValidateGrowingPlan.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Validation d'un dispositif.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 0.8
 */
public class ValidateGrowingPlan extends AbstractAgrosystAction {

    private static final long serialVersionUID = 7870593861396383646L;

    protected GrowingPlanService growingPlanService;

    protected String growingPlanTopiaId;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "growing-plans-edit-input", "growingPlanTopiaId", "${growingPlanTopiaId}"})})
    public String execute() throws Exception {
        GrowingPlan growingPlan = growingPlanService.validate(growingPlanTopiaId);

        notificationSupport.growingPlanValidated(growingPlan);
        return SUCCESS;
    }

    public String getGrowingPlanTopiaId() {
        return growingPlanTopiaId;
    }
}
