package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesListJson.java 1948 2013-10-29 16:52:59Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GenericEntitiesListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -4267342874222046159L;

    protected String genericClassName;

    protected String filter;

    protected ResultList<?> elements;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    @Override
    public String execute() {
        GenericFilter rawFilter = getGson().fromJson(filter, GenericFilter.class);
        elements = service.listEntitiesFromString(genericClassName, rawFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return elements;
    }
}
