package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveMeasurementsEditJson.java 2499 2013-12-16 22:32:55Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveMeasurementsEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;

import com.google.common.base.Preconditions;

import fr.inra.agrosyst.api.entities.MeasurementType;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.referentiels.RefMesure;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * JSON action to retrieve a <code>list</code> of {@link RefMesure} according to a given filter.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class EffectiveMeasurementsEditJson extends AbstractJsonAction {

    private static final long serialVersionUID = -4576065541768079736L;

    protected MeasurementService measurementService;

    protected MeasurementType measurementType;

    protected VariableType variableType;

    protected String cropFamily;

    protected String vegetativeProfile;

    protected Object jsonData;

    public void setMeasurementObservationService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    public void setMeasurementType(MeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public void setCropFamily(String cropFamily) {
        this.cropFamily = cropFamily;
    }

    public void setVegetativeProfile(String vegetativeProfile) {
        this.vegetativeProfile = vegetativeProfile;
    }

    @Action("effective-measurements-variable-types-json")
    public String listVariableTypes() throws Exception {
        jsonData = measurementService.findAllVariableTypes(measurementType);
        return SUCCESS;
    }
    
    @Action("effective-measurements-variables-json")
    public String listVariables() throws Exception {
        jsonData = measurementService.findAllVariables(measurementType, variableType);
        return SUCCESS;
    }

    @Action("effective-measurements-stades-json")
    public String listStadeEdis() throws Exception {
        Preconditions.checkArgument(cropFamily != null ^ vegetativeProfile != null);
        jsonData = measurementService.findAllStadeEdi(cropFamily, vegetativeProfile);
        return SUCCESS;
    }
    
    @Action("effective-measurements-vgobs-labels-json")
    public String listVgobsLabels() throws Exception {
        jsonData = measurementService.findAllProtocoleVgObsLabels();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
