package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveCropCyclesListJson.java 1686 2013-10-16 16:22:56Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveCropCyclesListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Display plots list that may be associated (or not) with crop cycles and cropping plan
 * intervention.
 * 
 * @author Eric Chatellier
 */
public class EffectiveCropCyclesListJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7710481757962881593L;

    protected EffectiveCropCycleService effectiveCropCycleService;

    protected String filter;

    /** Liste des zones (point d'entrée des cycles réalisés). */
    protected ResultList<Zone> zoneListResult;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() throws Exception {
        EffectiveZoneFilter plotFilter = getGson().fromJson(filter, EffectiveZoneFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        plotFilter.setNavigationContext(navigationContext);
        plotFilter.setPageSize(getConfig().getListResultsPerPage());
        zoneListResult = effectiveCropCycleService.getFilteredZones(plotFilter);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return zoneListResult;
    }
}
