package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveCropCyclesList.java 2091 2013-11-09 20:06:21Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveCropCyclesList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Display plots list that may be associated (or not) with crop cycles and cropping plan
 * intervention.
 * 
 * @author Eric Chatellier
 */
public class EffectiveCropCyclesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7710481757962881593L;

    protected EffectiveCropCycleService effectiveCropCycleService;

    /** Liste des zones (point d'entrée des cycles réalisés). */
    protected ResultList<Zone> zoneListResult;

    /** Flag to use current zone list as entry point for measurement. */
    protected boolean measurement;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    @Override
    public String execute() throws Exception {
        EffectiveZoneFilter plotFilter = new EffectiveZoneFilter();
        NavigationContext navigationContext = getNavigationContext();
        plotFilter.setNavigationContext(navigationContext);
        plotFilter.setPageSize(getConfig().getListResultsPerPage());
        zoneListResult = effectiveCropCycleService.getFilteredZones(plotFilter);
        return SUCCESS;
    }

    public ResultList<Zone> getZoneListResult() {
        return zoneListResult;
    }

    public boolean isMeasurement() {
        return measurement;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }
}
