package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ValidateDomain.java 2378 2013-12-04 18:12:48Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/ValidateDomain.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Validation d'un domaine.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 0.8
 */
public class ValidateDomain extends AbstractAgrosystAction {

    private static final long serialVersionUID = 8258866040086672722L;

    protected DomainService domainService;

    protected String domainTopiaId;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "domains-edit-input", "domainTopiaId", "${domainTopiaId}"})})
    public String execute() throws Exception {
        Domain domain = domainService.validate(domainTopiaId);

        notificationSupport.domainValidated(domain);
        return SUCCESS;
    }

    public String getDomainTopiaId() {
        return domainTopiaId;
    }

}
