package fr.inra.agrosyst.web.actions.domains;

import java.util.List;

import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListRefLocationJson.java 971 2013-08-21 11:29:57Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/ListRefLocationJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * Action de retourner la liste des communes
 *
 * @author David Cossé
 */
public class ListRefLocationJson extends AbstractJsonAction {

    private static final long serialVersionUID = 3930228731417892430L;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected List<RefLocation> communes;

    protected String term;

    @Override
    public String execute() {
        communes = referentielService.findActiveCommunes(term);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return communes;
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }

    public String getTerm() {
        return term;
    }

    public void setTerm(String term) {
        this.term = term;
    }
}
