/*
 * #%L
 * Agrosyst :: Web
 * $Id: GPSDataDto.java 1630 2013-10-09 19:22:29Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/GPSDataDto.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.domains;

import java.io.Serializable;

import com.google.common.base.Strings;

/**
 * DTO de GPSData.
 * 
 * @author David Cossé
 */
public class GPSDataDto implements Serializable {

    private static final long serialVersionUID = 197457017317376522L;

    protected String topiaId;

    protected String name;

    protected Double longitude;

    protected Double latitude;

    protected String description;

    public GPSDataDto() {
    }

    public GPSDataDto(String topiaId, String name, Double longitude,
                      Double latitude, String description) {
        this.topiaId = topiaId;
        this.name = name;
        this.longitude = longitude;
        this.latitude = latitude;
        this.description = description;
    }

    /**
     * 
     * @return vrai si tous les champs obligatoires sont remplis
     */
    public boolean isValid() {
        boolean result =
                !Strings.isNullOrEmpty(name)
                && latitude != null
                && longitude != null;
        return result;
    }

    public void setName(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.name = name;
        }
    }
    
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public Double getLongitude() {
        return longitude;
    }
    
    public Double getLatitude() {
        return latitude;
    }
    
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
