package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: CheckForCroppingPlanUsed.java 2333 2013-11-29 18:04:27Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/CheckForCroppingPlanUsed.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class CheckForCroppingPlanUsed extends AbstractJsonAction {

    protected String croppingPlanCode;

    protected PracticedSystemService practicedSystemService;

    protected Map<String, String> practicedSytemsNamesAndIds;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public String getCroppingPlanCode() {
        return croppingPlanCode;
    }

    public void setCroppingPlanCode(String croppingPlanCode) {
        this.croppingPlanCode = croppingPlanCode;
    }

    @Override
    public String execute() {
        practicedSytemsNamesAndIds = practicedSystemService.getPracticedSystemsNameAndIdForCrop(croppingPlanCode);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return practicedSytemsNamesAndIds;
    }
}
