package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ShowLocationRaw.java 2433 2013-12-11 09:34:19Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/ShowLocationRaw.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class ShowLocationRaw extends AbstractAgrosystAction {

    private static final long serialVersionUID = -3545222983056002193L;

    protected ReferentielService referentielService;

    protected double latitude;
    protected double longitude;
    protected String locationId;
    protected String name;

    protected String provider;
    protected RefLocation location;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    @Override
    public String execute() throws Exception {
        provider = "Esri.WorldImagery";
        if (!Strings.isNullOrEmpty(locationId)) {
            location = referentielService.getRefLocation(locationId);
        }
        return SUCCESS;
    }

    public String getLatitude() {
        return String.format("%.5f", latitude).replaceAll(",", ".");
    }

    public String getLongitude() {
        return String.format("%.5f", longitude).replaceAll(",", ".");
    }

    public String getName() {
        return Strings.emptyToNull(name);
    }

    public String getProvider() {
        return provider;
    }

    public RefLocation getLocation() {
        return location;
    }
}
