package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AttachmentsDeleteJson.java 2159 2013-11-14 15:47:34Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AttachmentsDeleteJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * This is the default action used to upload a file attached to a given object reference ID.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class AttachmentsDeleteJson extends AbstractJsonAction {

    private static final long serialVersionUID = 1864154104471757665L;

    protected AttachmentService attachmentService;

    protected String attachmentTopiaId;

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setAttachmentTopiaId(String attachmentTopiaId) {
        this.attachmentTopiaId = attachmentTopiaId;
    }

    @Override
    public String execute() throws Exception {
        attachmentService.delete(attachmentTopiaId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return null;
    }
}
