package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunExport.java 2429 2013-12-10 22:28:59Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunExport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.referentiels.*;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referentiels.ExportService;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class RunExport extends AbstractAdminAction {

    private static final Log log = LogFactory.getLog(RunExport.class);

    private static final long serialVersionUID = -5821886179843474360L;

    protected ExportService exportService;

    public void setImportService(ExportService exportService) {
        this.exportService = exportService;
    }

    protected String genericClassName;
    protected List<String> entityIds;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "text/csv",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        checkIsAdmin();
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream = null;
        try {
            Class<?> klass = Class.forName(genericClassName);
            
            if (RefSolArvalis.class.equals(klass)) {
                inputStream = exportService.exportSolArvalisCSV(entityIds);
            }

            /*if (RefLocation.class.equals(klass)) {
                can't export this one
            }*/

            if (RefMaterielTraction.class.equals(klass)) {
                inputStream = exportService.exportMaterielTracteursCSV(entityIds);
            }

            if (RefMaterielIrrigation.class.equals(klass)) {
                inputStream = exportService.exportMaterielIrrigationCSV(entityIds);
            }

            if (RefMaterielAutomoteur.class.equals(klass)) {
                inputStream = exportService.exportMaterielAutomoteursCSV(entityIds);
            }

            if (RefMaterielOutil.class.equals(klass)) {
                inputStream = exportService.exportMaterielOutilsCSV(entityIds);
            }

            if (RefLegalStatus.class.equals(klass)) {
                inputStream = exportService.exportLegalStatusCSV(entityIds);
            }

            if (RefEspece.class.equals(klass)) {
                inputStream = exportService.exportEspeces(entityIds);
            }

            if (RefVarieteGeves.class.equals(klass)) {
                inputStream = exportService.exportVarietesGeves(entityIds);
            }

            if (RefEspeceToVariete.class.equals(klass)) {
                inputStream = exportService.exportEspecesToVarietes(entityIds);
            }

            if (RefOTEX.class.equals(klass)) {
                inputStream = exportService.exportOtexCSV(entityIds);
            }

            if (RefClonePlantGrape.class.equals(klass)) {
                inputStream = exportService.exportClonesPlantGrape(entityIds);
            }

            if (RefVarietePlantGrape.class.equals(klass)) {
                inputStream = exportService.exportVarietesPlantGrape(entityIds);
            }

            if (RefOrientationEDI.class.equals(klass)) {
                inputStream = exportService.exportOrientationEdiCSV(entityIds);
            }

            if (RefSolTextureGeppa.class.equals(klass)) {
                inputStream = exportService.exportSolTextureGeppa(entityIds);
            }

            if (RefParcelleZonageEDI.class.equals(klass)) {
                inputStream = exportService.exportZonageParcelleEdi(entityIds);
            }

            if (RefSolProfondeurIndigo.class.equals(klass)) {
                inputStream = exportService.exportSolProfondeurIndigo(entityIds);
            }

            if (RefSolCaracteristiquesIndigo.class.equals(klass)) {
                inputStream = exportService.exportSolCarateristiquesIndigo(entityIds);
            }
            
            if (RefAdventices.class.equals(klass)) {
                inputStream = exportService.exportAdventices(entityIds);
            }
            
            if (RefNuisiblesEDI.class.equals(klass)) {
                inputStream = exportService.exportNuisiblesEDI(entityIds);
            }
            
            if (RefFertiEngraisorg.class.equals(klass)) {
                inputStream = exportService.exportFertiEngraisOrg(entityIds);
            }
            
            if (RefFertiMinUNIFA.class.equals(klass)) {
                inputStream = exportService.exportFertiMinUNIFA(entityIds);
            }
            
            if (RefFertiTypesEffluents.class.equals(klass)) {
                inputStream = exportService.exportFertiMinUNIFA(entityIds);
            }
            
            if (RefTypeTravailEDI.class.equals(klass)) {
                inputStream = exportService.exportTypeTravailEdiCSV(entityIds);
            }
            
            if (RefInterventionAgrosystTravailEDI.class.equals(klass)) {
                inputStream = exportService.exportInterventionAgrosystTravailEdiCSV(entityIds);
            }
            
            if (RefStadeEDI.class.equals(klass)) {
                inputStream = exportService.exportStadesEdiCSV(entityIds);
            }
            
            if (RefUnitesEDI.class.equals(klass)) {
                inputStream = exportService.exportUnitesEdi(entityIds);
            }
            
            if (RefStationMeteo.class.equals(klass)) {
                inputStream = exportService.exportStationMeteo(entityIds);
            }
            
            if (RefFertiEngraisorg.class.equals(klass)) {
                inputStream = exportService.exportFertiEngraisOrg(entityIds);
            }
            
            if (RefGesCarburants.class.equals(klass)) {
                inputStream = exportService.exportGesCarburants(entityIds);
            }
            
            if (RefGesEngrais.class.equals(klass)) {
                inputStream = exportService.exportGesEngrais(entityIds);
            }
            
            if (RefGesPhyto.class.equals(klass)) {
                inputStream = exportService.exportGesPhyto(entityIds);
            }
            
            if (RefGesSemences.class.equals(klass)) {
                inputStream = exportService.exportGesSemences(entityIds);
            }
            
            if (RefNrjCarburants.class.equals(klass)) {
                inputStream = exportService.exportNrjCarburants(entityIds);
            }
            
            if (RefNrjEngrais.class.equals(klass)) {
                inputStream = exportService.exportNrjEngrais(entityIds);
            }

            if (RefNrjPhyto.class.equals(klass)) {
                inputStream = exportService.exportNrjPhyto(entityIds);
            }

            if (RefNrjSemences.class.equals(klass)) {
                inputStream = exportService.exportNrjSemences(entityIds);
            }

            if (RefNrjGesOutils.class.equals(klass)) {
                inputStream = exportService.exportNrjGesOutils(entityIds);
            }

            if (RefMesure.class.equals(klass)) {
                inputStream = exportService.exportMesure(entityIds);
            }

            if (RefSupportOrganeEdi.class.equals(klass)) {
                inputStream = exportService.exportSupportOrganeEdi(entityIds);
            }
            
            if (RefStadeNuisibleEDI.class.equals(klass)) {
                inputStream = exportService.exportStadeNuisibleEDI(entityIds);
            }
            
            if (RefTypeNotationEDI.class.equals(klass)) {
                inputStream = exportService.exportTypeNotationEDI(entityIds);
            }
            
            if (RefValeurQualitativeEDI.class.equals(klass)) {
                inputStream = exportService.exportValeurQualitativeEDI(entityIds);
            }
            
            if (RefUnitesQualifiantEDI.class.equals(klass)) {
                inputStream = exportService.exportUnitesQualifiantEDI(entityIds);
            }

            if (RefActaSubstanceActive.class.equals(klass)) {
                inputStream = exportService.exportActaSubstanceActive(entityIds);
            }

            if (RefProtocoleVgObs.class.equals(klass)) {
                inputStream = exportService.exportProtocoleVgObs(entityIds);
            }
            
            if (RefElementVoisinage.class.equals(klass)) {
                inputStream = exportService.exportElementVoisinage(entityIds);
            }

        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate csv", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "export" + StringUtils.substringAfterLast(genericClassName, ".") + ".csv";
        return filename;
    }
}
