package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractAdminAction.java 2429 2013-12-10 22:28:59Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/AbstractAdminAction.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.*;
import fr.inra.agrosyst.api.entities.referentiels.*;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public abstract class AbstractAdminAction extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -5817371954801847984L;

    protected static final Class[] AUTHORITY_BASE_CLASSES = new Class[]{
            AgrosystInterventionType.class,
            CapacityUnit.class,
            CategoryObjective.class,
            CategoryStrategy.class,
            ChemicalElement.class,
            CropCyclePhaseType.class,
            CroppingEntryType.class,
            DomainType.class,
            FertilizerQuantityUnit.class,
            FrostProtectionType.class,
            HorizonType.class,
            HosesPositionning.class,
            IrrigationSystemType.class,
            ManagementModeCategory.class,
            MaxSlope.class,
            MeasurementType.class,
            MeasureType.class,
            NitrogenMolecule.class,
            OrchardFrutalForm.class,
            PollinatorSpreadMode.class,
            PompEngineType.class,
            PracticedSystemSource.class,
            ProductivityType.class,
            SectionType.class,
            Sector.class,
            SeedType.class,
            SolWaterPh.class,
            StrategyType.class,
            TypeDEPHY.class,
            UnitPlantSeeds.class,
            VineFrutalForm.class,
            WaterFlowDistance.class,
            WeedType.class,
            YealdCategory.class,
            YealdUnit.class,
            Zoning.class,
            ZoneType.class
    };

    protected static final Class[] REFERENTIAL_BASE_CLASSES = new Class[]{
            RefActaDosageSa.class,
            RefActaTraitementsProduits.class,
            RefFertiMinUNIFA.class,
            RefLocation.class,
            RefSolArvalis.class,
            RefLegalStatus.class,
            RefMaterielAutomoteur.class,
            RefMaterielIrrigation.class,
            RefMaterielTraction.class,
            RefMaterielOutil.class,
            RefEspece.class,
            RefVarieteGeves.class,
            RefVarietePlantGrape.class,
            RefClonePlantGrape.class,
            RefEspeceToVariete.class,
            RefOrientationEDI.class,
            RefOTEX.class,
            RefTypeTravailEDI.class,
            RefInterventionAgrosystTravailEDI.class,
            RefStadeEDI.class,
            RefParcelleZonageEDI.class,
            RefSolProfondeurIndigo.class,
            RefSolTextureGeppa.class,
            RefSolCaracteristiquesIndigo.class,
            RefStationMeteo.class,
            RefUnitesEDI.class,
            RefAdventices.class,
            RefNuisiblesEDI.class,
            RefFertiEngraisorg.class,
            RefFertiOrga.class,
            RefGesCarburants.class,
            RefGesEngrais.class,
            RefGesPhyto.class,
            RefGesSemences.class,
            RefNrjCarburants.class,
            RefNrjEngrais.class,
            RefNrjPhyto.class,
            RefNrjSemences.class,
            RefNrjGesOutils.class,
            RefMesure.class,
            RefSupportOrganeEdi.class,
            RefActaSubstanceActive.class,
            RefProtocoleVgObs.class,
            RefStadeNuisibleEDI.class,
            RefTypeNotationEDI.class,
            RefValeurQualitativeEDI.class,
            RefUnitesQualifiantEDI.class,
            RefElementVoisinage.class
    };
    protected static final Function<Class, String> GET_CLASS_NAME = new Function<Class, String>() {
        @Override
        public String apply(Class input) {
            return input.getName();
        }
    };

    protected static List<String> authorityBaseClassNames;
    protected static List<String> referentialBaseClassNames;

    protected Map<String, Long> referentialClasses;

    protected Map<String, Long> authorityClasses;

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    protected void checkIsAdmin() {
        authorizationService.checkIsAdmin();
    }

    protected void sortFromI18n(Class<?>... classes) {
        Arrays.sort(classes, new Comparator<Class<?>>() {
            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                String className1 = o1.getName();
                String className2 = o2.getName();
                String text1 = getText(className1, className1);
                String text2 = getText(className2, className2);
                return text1.compareTo(text2);
            }
        });
    }

    protected static void resetReferentialBaseClassesList() {
        referentialBaseClassNames = Lists.newArrayList();
        Iterables.addAll(referentialBaseClassNames, Iterables.transform(Arrays.asList(REFERENTIAL_BASE_CLASSES), GET_CLASS_NAME));
    }

    protected static void resetAuthorityBaseClassesList() {
        authorityBaseClassNames = Lists.newArrayList();
        Iterables.addAll(authorityBaseClassNames, Iterables.transform(Arrays.asList(AUTHORITY_BASE_CLASSES), GET_CLASS_NAME));
    }

    @Override
    public void prepare() throws Exception {
        if (referentialBaseClassNames == null) {
            sortFromI18n(REFERENTIAL_BASE_CLASSES);
            resetReferentialBaseClassesList();
        }
        if (authorityBaseClassNames == null) {
            sortFromI18n(AUTHORITY_BASE_CLASSES);
            resetAuthorityBaseClassesList();
        }

        referentialClasses = service.countEntitiesFromString(referentialBaseClassNames);
        authorityClasses = service.countEntitiesFromString(authorityBaseClassNames);

    }

    public Map<String, Long> getReferentialClasses() {
        return referentialClasses;
    }

    public Map<String, Long> getAuthorityClasses() {
        return authorityClasses;
    }

}
