package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebFileUploadInterceptor.java 2319 2013-11-28 16:32:19Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebFileUploadInterceptor.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ValidationAware;
import fr.inra.agrosyst.web.actions.admin.RunImport;
import org.apache.struts2.interceptor.FileUploadInterceptor;

import java.io.File;
import java.util.Map;

/**
 * On surcharge {@link org.apache.struts2.interceptor.FileUploadInterceptor} pour aller
 * chercher la taille maximum autorisée et les extensions autorisées dans la configuration.
 *
 * @author kmorin : kmorin@codelutin.com
 * @since 0.8
 */
public class AgrosystWebFileUploadInterceptor extends FileUploadInterceptor {

    private static final long serialVersionUID = 1L;

    @Override
    protected boolean acceptFile(Object action, File file, String filename, String contentType, String inputName, ValidationAware validation) {

        if (!(action instanceof RunImport) &&
                (allowedTypesSet == null || allowedTypesSet.isEmpty())) {

            Map<String, Object> application = ActionContext.getContext().getApplication();

            AgrosystWebApplicationContext applicationContext =
                    (AgrosystWebApplicationContext) application.get(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);

            AgrosystWebConfig config = applicationContext.getWebConfig();

            setAllowedExtensions(config.getUploadAllowedExtensions());

            setMaximumSize(config.getUploadMaxSize());

        }

        return super.acceptFile(action, file, filename, contentType, inputName, validation);

    }

}
