package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationListener.java 2318 2013-11-28 16:26:30Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationListener.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Method;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystWebApplicationListener implements ServletContextListener {

    private static final Log log = LogFactory.getLog(AgrosystWebApplicationListener.class);

    protected AgrosystWebApplicationContext context;

    @Override
    public void contextInitialized(ServletContextEvent sce) {

        if (log.isInfoEnabled()) {
            log.info("Initializing Agrosyst Web Module");
        }

        context = new AgrosystWebApplicationContext();
        context.init();

        sce.getServletContext().setAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER, context);

        checkForDemoData();
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Destroy Agrosyst Web Module");
        }

        context.close();
    }

    protected void checkForDemoData() {
        if (!context.getWebConfig().isServicesRemoteEnabled()) {
            try {
                Class<?> demoDataClass = Class.forName("fr.inra.agrosyst.services.demo.DemoDatas");
                Method method = demoDataClass.getMethod("onInit");
                method.invoke(null);
            } catch (Exception eee) {
                throw new AgrosystTechnicalException("Unable to initialize data", eee);
            }
        }
    }

}
