package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationContext.java 2346 2013-12-02 10:30:37Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationContext.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaApplicationContextCache;

import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultConfigurationSupplier;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystWebApplicationContext {

    private static final Log log = LogFactory.getLog(AgrosystWebApplicationContext.class);

    public static final String APPLICATION_CONTEXT_PARAMETER = AgrosystWebApplicationContext.class.getName();

    public static final String MISSING_APPLICATION_CONTEXT =
            AgrosystWebApplicationContext.class.getSimpleName() + " not found. You probably forgot to" +
                    " register " + AgrosystWebApplicationListener.class.getName() + " in your web.xml";

    protected AgrosystWebConfig webConfig;

    protected Object serviceConfig;

    protected AgrosystTopiaApplicationContext applicationContext;

    public void init() {

        webConfig = new AgrosystWebConfig();
        webConfig.parse();

        if (!webConfig.isServicesRemoteEnabled()) {
            try {
//                Class<?> defaultConfigSupplierClass = Class.forName("fr.inra.agrosyst.services.DefaultConfigurationSupplier");
//                serviceConfig = defaultConfigSupplierClass.getMethod("getDefaultConfiguration").invoke(null);
//
//                Class<?> applicationContextClass = Class.forName("fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext");
//                serviceConfig = defaultConfigSupplierClass.getConstructor(Properties.class);
                AgrosystServiceConfig config = DefaultConfigurationSupplier.getDefaultConfiguration();
                serviceConfig = config;

                Properties contextProperties = DefaultConfigurationSupplier.getRootContextProperties(config);
                applicationContext = TopiaApplicationContextCache.getContext(contextProperties, DefaultConfigurationSupplier.CREATE_CONTEXT_FUNCTION);
            } catch (Exception eee) {
                throw new AgrosystTechnicalException("Un exception occurred", eee);
            }

        }
    }

    public AgrosystWebConfig getWebConfig() {
        return webConfig;
    }

    public Object getServiceConfig() {
        return serviceConfig;
    }

    public AgrosystTopiaApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void close() {
        if (applicationContext != null && !applicationContext.isClosed()) {
            applicationContext.closeContext();
        }
    }

}
