package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersList.java 1585 2013-10-07 15:53:58Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * User list action.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class UsersList extends AbstractAdminAction {

    private static final long serialVersionUID = -4895779258937582288L;

    protected UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    /**
     * User result list serialized as JSON.
     */
    protected ResultList<UserDto> users;

    @Override
    public String execute() throws Exception {
        checkIsAdmin();
        UserFilter userFilter = new UserFilter();
        userFilter.setPageSize(getConfig().getListResultsPerPage());
        users = userService.getFilteredUsers(userFilter, true);
        return SUCCESS;
    }

    public ResultList<UserDto> getUsers() {
        return users;
    }

    public Map<RoleType, String> getRoleTypes() {
        return getEnumAsMap(RoleType.values());
    }

}
