package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsListJson.java 828 2013-08-06 13:39:32Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.PracticedSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class PracticedSystemsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -7042498750101369083L;

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    protected ResultList<PracticedSystem> practicedSystems;

    protected String filter;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        PracticedSystemFilter pracfilter = getGson().fromJson(filter, PracticedSystemFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        pracfilter.setNavigationContext(navigationContext);
        practicedSystems = practicedSystemService.getFilteredPracticedSystems(pracfilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return practicedSystems;
    }
}
