package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefStadesEdiJson.java 1764 2013-10-21 15:42:55Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefStadesEdiJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * Chargement des StadeEdis
 * 
 * @author cosse
 */
public class LoadRefStadesEdiJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4680946995049096766L;

    protected ReferentielService referentielService;

    protected String vegetativeProfile;

    protected Map<String, RefStadeEdiDto> stadesEdiDto;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }


    @Override
    public String execute() throws Exception {

        if (StringUtils.isNumeric(vegetativeProfile)) {
            stadesEdiDto = referentielService.getRefStadesEdi(Integer.valueOf(vegetativeProfile));
        }

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return stadesEdiDto;
    }

    public void setVegetativeProfile(String vegetativeProfile) {
        this.vegetativeProfile = vegetativeProfile;
    }
}
