package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefInterventionAgrosystTravailEdisJson.java 2053 2013-11-07 15:21:43Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefInterventionAgrosystTravailEdisJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referentiels.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * Chargement des {@link RefActionAgrosystTravailEDI} au moment où on choisit le type d'action.
 * 
 * @author Eric Chatellier
 */
public class LoadRefInterventionAgrosystTravailEdisJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5842359927618631165L;

    protected AgrosystInterventionType agrosystInterventionType;

    protected List<RefInterventionAgrosystTravailEDI> interventionAgrosystTravailEDIs;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        interventionAgrosystTravailEDIs = referentielService.getRefInterventionAgrosystTravailEDIs(agrosystInterventionType);
        return SUCCESS;
    }
    @Override
    public Object getJsonData() {
        return interventionAgrosystTravailEDIs;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }
}
