package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadProductUnitsJson.java 1541 2013-10-03 16:49:58Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadProductUnitsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadProductUnitsJson  extends AbstractJsonAction {

    protected String productTopiaId;

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService){
        this.practicedSystemService = practicedSystemService;
    }

    protected List<String> productUnits;

    @Override
    public String execute(){
        productUnits= practicedSystemService.getAllPriceUnits(productTopiaId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return productUnits;
    }

    public void setProductTopiaId(String productTopiaId) {
        this.productTopiaId = productTopiaId;
    }
}
