package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadPerennialCroppingPlanSpeciesJson.java 1968 2013-10-30 16:43:08Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadPerennialCroppingPlanSpeciesJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Chargement des espèces d'une culture si vraiment l'utilisateur change la culture d'un
 * cycle de cultures pérennes.
 * 
 * @author cosse
 */
public class LoadPerennialCroppingPlanSpeciesJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4680946995049096766L;

    protected PracticedSystemService practicedSystemService;

    protected String croppingPlanEntryCode;

    protected String campaigns;

    protected List<PracticedCropCycleSpeciesDto> cropCyclePerennialSpeciesDtos;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setCroppingPlanEntryCode(String croppingPlanEntryCode) {
        this.croppingPlanEntryCode = croppingPlanEntryCode;
    }

    @Override
    public String execute() throws Exception {
        cropCyclePerennialSpeciesDtos = practicedSystemService.getCropCyclePerennialSpecies(croppingPlanEntryCode, null, campaigns);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return cropCyclePerennialSpeciesDtos;
    }
}
