package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadFertyTypesEffluentsJson.java 1537 2013-10-03 16:36:04Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadFertyTypesEffluentsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referentiels.RefFertiTypesEffluents;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadFertyTypesEffluentsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 6788304545377822497L;

    protected List<RefFertiTypesEffluents> refFertiTypesEffluents;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        refFertiTypesEffluents = referentielService.findAllActiveRefFertiTypesEffluents();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return refFertiTypesEffluents;
    }
}
