/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesList.java 2060 2013-11-07 17:35:25Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.performances;

import fr.inra.agrosyst.api.entities.Performance;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PerformancesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1180723133330637375L;

    protected PerformanceService performanceService;

    protected boolean practiced;

    protected ResultList<Performance> performances;

    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    public boolean isPracticed() {
        return practiced;
    }

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public String execute() {
        performances = performanceService.getFilterPerformances(practiced);
        return SUCCESS;
    }

    public ResultList<Performance> getPerformances() {
        return performances;
    }
}
