/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesEdit.java 2061 2013-11-07 17:48:26Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.performances;

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Performance;
import fr.inra.agrosyst.api.entities.PerformanceImpl;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PerformancesEdit extends AbstractAgrosystAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 525633506544808582L;

    protected PerformanceService performanceService;

    protected GrowingSystemService growingSystemService;
    
    protected DomainService domainService;

    protected Performance performance;

    protected String performanceTopiaId;

    protected List<GrowingSystem> growingSystems;

    protected String growingSystemId;
    
    protected List<Domain> domains;

    protected String domainId;

    /** Flag used to use interface for practiced or not. */
    protected boolean practiced;

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return domainId;
    }

    public void setPerformanceTopiaId(String performanceTopiaId) {
        this.performanceTopiaId = performanceTopiaId;
    }

    public String getPerformanceTopiaId() {
        return performanceTopiaId;
    }

    public String getGrowingSystemId() {
        return growingSystemId;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public boolean isPracticed() {
        return practiced;
    }

    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    public Performance getPerformance() {
        if (performance == null) {
            // EChatellier 27/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new PerformanceImpl();
        }
        return performance;
    }

    @Override
    public void prepare() throws Exception {
        performance = performanceService.getPerformance(performanceTopiaId);
    }

    @Override
    @Action("performances-edit-input")
    public String input() throws Exception {
        initForInput();
        
        if (performance.getGrowingSystem() != null) {
            growingSystemId = performance.getGrowingSystem().getTopiaId();
        }
        if (performance.getDomain() != null) {
            domainId = performance.getDomain().getTopiaId();
        }
        return INPUT;
    }

    @Override
    protected void initForInput() {
        
        // growing systems
        GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
        NavigationContext navigationContext = getNavigationContext();
        growingSystemFilter.setNavigationContext(navigationContext);
        growingSystemFilter.setActive(true);
        growingSystemFilter.setPageSize(GrowingPlanFilter.ALL_PAGE_SIZE);
        ResultList<GrowingSystem> growingSystemListResult = growingSystemService.getFilteredGrowingSystems(growingSystemFilter);
        growingSystems = Lists.newArrayList(growingSystemListResult.getElements());
        
        // domain
        ResultList<Domain> domainListResult = domainService.getFilteredDomains(growingSystemFilter);
        domains = domainListResult.getElements();
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "performances-edit-input", "performanceTopiaId", "${performance.topiaId}", "practiced", "${practiced}"})})
    public String execute() {

        // special management for 'practiced' flag
        if (!performance.isPersisted()) {
            performance.setPracticed(practiced);
        }
        performance = performanceService.updatePerformance(performance, growingSystemId, domainId);
        notificationSupport.performanceSaved(performance);

        return SUCCESS;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }
    
    public List<Domain> getDomains() {
        return domains;
    }
}
