/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksUnactivate.java 1822 2013-10-22 14:48:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.networks;

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Désactivation multiple de réseaux.
 *
 * @author Eric Chatellier
 */
public class NetworksUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected NetworkService networkService;

    protected List<String> networkIds;

    protected boolean activate;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setNetworkIds(List<String> networkIds) {
        this.networkIds = networkIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "actionName", "networks-list"})})
    public String execute() throws Exception {
        networkService.unactivateNetworks(networkIds, activate);
        return SUCCESS;
    }

}
