/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksList.java 1822 2013-10-22 14:48:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.networks;

import java.util.List;
import java.util.Set;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.network.NetworkConnectionDto;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkGraph;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.network.SmallNetworkDto;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Affichage de la liste des réseaux et du graphique des réseaux.
 *
 * @author cosse
 */
public class NetworksList extends AbstractAgrosystAction {

    private static final long serialVersionUID = 4474047833187143193L;

    protected NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected ResultList<Network> networks;

    protected NetworkGraph networksGraph;

    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        NetworkFilter filter = new NetworkFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        networks = networkService.getFilteredNetworks(filter);

        networksGraph = networkService.buildFullNetworkGraph();

        return SUCCESS;
    }

    public ResultList<Network> getNetworks() {
        return networks;
    }

    public List<List<SmallNetworkDto>> getGraphNetworks() {
        return networksGraph.getNetworks();
    }

    public Set<NetworkConnectionDto> getGraphConnections() {
        return networksGraph.getConnections();
    }

}
