/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesList.java 1518 2013-10-03 09:02:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.ManagementMode;
import fr.inra.agrosyst.api.entities.ManagementModeCategory;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Management modes list action.
 * 
 * @author Eric Chatellier
 */
public class ManagementModesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5032928580196001618L;

    protected ManagementModeService managementModeService;

    protected ResultList<ManagementMode> managementModes;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        ManagementModeFilter filter = new ManagementModeFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        managementModes = managementModeService.getFilteredManagementModes(filter);

        return SUCCESS;
    }

    public ResultList<ManagementMode> getManagementModes() {
        return managementModes;
    }

    public Map<ManagementModeCategory, String> getManagementModeCategories() {
        return getEnumAsMap(ManagementModeCategory.values());
    }
}
