/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesListJson.java 1518 2013-10-03 09:02:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DecisionRule;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Decision rules list json action.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesListJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7454396591234192201L;

    protected ManagementModeService managementModeService;

    protected String filter;

    protected ResultList<DecisionRule> decisionRules;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        DecisionRuleFilter decisionRulefilter = getGson().fromJson(filter, DecisionRuleFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        decisionRulefilter.setNavigationContext(navigationContext);
        decisionRules = managementModeService.getFilteredDecisionRules(decisionRulefilter);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return decisionRules;
    }
}
