/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesList.java 1518 2013-10-03 09:02:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DecisionRule;
import fr.inra.agrosyst.api.entities.InterventionType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Decision rule list action.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8916181887544412258L;

    protected ManagementModeService managementModeService;

    protected ResultList<DecisionRule> decisionRules;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        DecisionRuleFilter filter = new DecisionRuleFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        decisionRules = managementModeService.getFilteredDecisionRules(filter);

        return SUCCESS;
    }

    public ResultList<DecisionRule> getDecisionRules() {
        return decisionRules;
    }

    public Map<InterventionType, String> getInterventionTypes() {
        return getEnumAsMap(InterventionType.values());
    }
}
