/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesEditJson.java 1518 2013-10-03 09:02:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import org.apache.struts2.convention.annotation.Action;

import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Decision rule edit json actions.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4109060690576341764L;

    protected ManagementModeService managementModeService;

    /** Growing system id (for decision-rules-edit-cropping-plan-entries-json). */
    protected String growingSystemTopiaId;

    /** Type de bio agresseur (for decision-rules-edit-bio-agressors-json). */
    protected String bioAgressorType;

    protected Object jsonData;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public void setBioAgressorType(String bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    /**
     * Récupération de la liste des cultures à la sélection d'un système de culture.
     * 
     * @return SUCCESS
     */
    @Action("decision-rules-edit-cropping-plan-entries-json")
    public String listCroppingPlanEntries() {
        jsonData = managementModeService.getGrowingSystemCroppingPlanEntries(growingSystemTopiaId);
        return SUCCESS;
    }

    /**
     * Recuperation de la liste des bio agresseurs filtrée par type.
     * 
     * @return SUCCESS
     */
    @Action("decision-rules-edit-bio-agressors-json")
    public String listBioAgressors() {
        jsonData = managementModeService.getBioAgressor(bioAgressorType);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
