package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsPlotsJson.java 1113 2013-09-03 14:20:15Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsPlotsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Recupere la liste des parcelles "libre" à la sélection d'un dispositif lors de la creation d'un
 * système de culture.
 * 
 * @author cosse
 */
public class GrowingSystemsPlotsJson extends AbstractJsonAction  {

    private static final long serialVersionUID = 7784391389093373240L;

    protected PlotService plotService;

    protected List<Plot> plots;

    protected String growingPlanTopiaId;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

    @Override
    public String execute() throws Exception {
        plots = plotService.getFreePlotForGrowingPlan(growingPlanTopiaId);
        return SUCCESS;
    }
 
    @Override
    public Object getJsonData() {
        return plots;
    }
}
