package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansListJson.java 1381 2013-09-18 15:37:30Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GrowingPlansListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -2087447831007638801L;

    protected GrowingPlanService growingPlanService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    protected String filter;
    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();
    protected Set<String> selectedDomains = Sets.newHashSet();

    protected ResultList<GrowingPlan> growingPlans;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    public void setSelectedDomains(Set<String> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    @Override
    public String execute() {
        GrowingPlanFilter growingPlanFilter = getGson().fromJson(filter, GrowingPlanFilter.class);
        NavigationContext navigationContext;
        if (selectedCampaigns.isEmpty() && selectedNetworks.isEmpty() && selectedDomains.isEmpty()) {
            navigationContext = getNavigationContext();
        } else {
            navigationContext = new NavigationContext();
            navigationContext.setCampaigns(selectedCampaigns);
            navigationContext.setNetworks(selectedNetworks);
            navigationContext.setDomains(selectedDomains);
        }
        growingPlanFilter.setNavigationContext(navigationContext);
        growingPlans = growingPlanService.getFilteredGrowingPlans(growingPlanFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return growingPlans;
    }

}
