package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveMeasurementsEditJson.java 2094 2013-11-10 15:54:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveMeasurementsEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;

import fr.inra.agrosyst.api.entities.MeasurementType;
import fr.inra.agrosyst.api.entities.referentiels.RefMesure;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * JSON action to retrieve a <code>list</code> of {@link RefMesure} according to a given filter.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class EffectiveMeasurementsEditJson extends AbstractJsonAction {

    private static final long serialVersionUID = -4576065541768079736L;

    protected MeasurementService measurementService;

    protected MeasurementType measurementType;

    protected String variableType;

    protected Object jsonData;

    public void setMeasurementObservationService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    public void setMeasurementType(MeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    @Action("effective-measurements-variable-types-json")
    public String listVariableTypes() throws Exception {
        jsonData = this.measurementService.findAllVariableTypes(measurementType);
        return SUCCESS;
    }
    
    @Action("effective-measurements-variables-json")
    public String listVariables() throws Exception {
        jsonData = this.measurementService.findAllVariables(measurementType, variableType);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
