package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveMeasurementsEdit.java 2113 2013-11-11 14:40:20Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveMeasurementsEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.gson.reflect.TypeToken;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.ChemicalElement;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.HorizonType;
import fr.inra.agrosyst.api.entities.MeasureType;
import fr.inra.agrosyst.api.entities.MeasurementSession;
import fr.inra.agrosyst.api.entities.MeasurementType;
import fr.inra.agrosyst.api.entities.NitrogenMolecule;
import fr.inra.agrosyst.api.entities.ProductivityType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.referentiels.RefSupportOrganeEdi;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Action used to list and edit all {@link MeasurementObservationSession} for a given {@link Zone}.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class EffectiveMeasurementsEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = 6018591779575353579L;

    protected MeasurementService measurementService;

    protected String zoneTopiaId;

    protected Zone zone;

    protected Set<CroppingPlanSpecies> croppingPlanSpecies;

    protected List<MeasurementSession> measurementSessions;

    protected List<RefSupportOrganeEdi> supportOrganeEdis;

    public void setMeasurementService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    public String getZoneTopiaId() {
        return zoneTopiaId;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        this.zoneTopiaId = zoneTopiaId;
    }

    public Zone getZone() {
        return zone;
    }

    @Override
    public void prepare() throws Exception {
        zone = measurementService.getZone(zoneTopiaId);
    }

    @Override
    @Action("effective-measurements-edit-input")
    public String input() throws Exception {
        initForInput();

        measurementSessions = measurementService.getZoneMeasurementSessions(zone);

        return INPUT;
    }

    @Override
    protected void initForInput() {
        croppingPlanSpecies = measurementService.getZoneCroppingPlanSpecies(zone);
        supportOrganeEdis = measurementService.findAllSupportOrganeEdi();
    }

    public Map<MeasurementType, String> getMeasurementMeasureTypes() {
        return getEnumAsMap(MeasurementType.PLANTE,
                        MeasurementType.SOL,
                        MeasurementType.TRANSFERT_DE_SOLUTES,
                        MeasurementType.GES,
                        MeasurementType.METEO);
    }

    public Map<MeasurementType, String> getMeasurementObservationTypes() {
        return getEnumAsMap(
                        MeasurementType.STADE_CULTURE,
                        MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES,
                        MeasurementType.ADVENTICES);
    }

    public Map<MeasureType, String> getMeasureTypes() {
        return getEnumAsMap(MeasureType.values());
    }

    public Map<ProductivityType, String> getProductivityTypes() {
        return getEnumAsMap(ProductivityType.values());
    }

    public Map<ChemicalElement, String> getChemicalElements() {
        return getEnumAsMap(ChemicalElement.values());
    }
    
    public Map<HorizonType, String> getHorizonTypes() {
        return getEnumAsMap(HorizonType.values());
    }
    
    public Map<NitrogenMolecule, String> getNitrogenMolecules() {
        return getEnumAsMap(NitrogenMolecule.values());
    }

    @Override
    public void validate() {

        if (hasErrors()) {
            initForInput();
        }
    }

    @Override
    @Action(results = {@Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "effective-measurements-edit-input", "zoneTopiaId", "${zoneTopiaId}"})})
    public String execute() throws Exception {

        measurementService.updateMeasurementSessions(zone, measurementSessions);

        return SUCCESS;
    }

    public List<MeasurementSession> getMeasurementSessions() {
        return measurementSessions;
    }

    public void setMeasurementSessions(String json) {
        Type type = new TypeToken<List<MeasurementSession>>() {}.getType();
        measurementSessions = getGson().fromJson(json, type);
    }

    public Set<CroppingPlanSpecies> getCroppingPlanSpecies() {
        return croppingPlanSpecies;
    }

    public List<RefSupportOrganeEdi> getSupportOrganeEdis() {
        return supportOrganeEdis;
    }
}
