package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: WeatherStationDto.java 2113 2013-11-11 14:40:20Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/WeatherStationDto.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * DTO used to edit {@link WeatherStation} from view.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class WeatherStationDto implements Serializable {

    private static final long serialVersionUID = -8332633331857450768L;

    protected String topiaId;
    protected String refStationMeteoTopiaId;
    protected String comment;
    protected String data;
    protected boolean defaultSelected = false;

    /**
     * @see WeatherStation#getTopiaId()
     */
    public String getTopiaId() {
        return topiaId;
    }

    /**
     * @see WeatherStation#setTopiaId(String)
     */
    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    /**
     * @see WeatherStation#getRefStationMeteo(){@link #getTopiaId()}
     */
    public String getRefStationMeteoTopiaId() {
        return refStationMeteoTopiaId;
    }

    /**
     * @see WeatherStation#getRefStationMeteo(){@link #getTopiaId()}
     */
    public void setRefStationMeteoTopiaId(String refStationMeteoTopiaId) {
        this.refStationMeteoTopiaId = refStationMeteoTopiaId;
    }

    /**
     * @see WeatherStation#getComment()
     */
    public String getComment() {
        return comment;
    }

    /**
     * @see WeatherStation#setComment(String)
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /**
     * @see WeatherStation#getData()
     */
    public String getData() {
        return data;
    }

    /**
     * @see WeatherStation#setData(String)
     */
    public void setData(String data) {
        this.data = data;
    }

    /**
     * Returns <code>true</code> if this {@link WeatherStationDto} instance is
     * the default selected.
     *
     * @return <code>true</code> if this {@link WeatherStationDto} instance is
     *         the default selected.
     */
    public boolean isDefaultSelected() {
        return defaultSelected;
    }

    /**
     * Sets this {@link WeatherStationDto} instance as the default selected or
     * not.
     *
     * @param defaultSelected <code>true</code> if this {@link WeatherStationDto} is the
     *                        default selected, <code>false</code> otherwise
     */
    public void setDefaultSelected(boolean defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

}
