package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefInterventionAgrosystTravailEdisJson.java 2146 2013-11-13 17:17:51Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/LoadRefInterventionAgrosystTravailEdisJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referentiels.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;


public class LoadRefInterventionAgrosystTravailEdisJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5842359927618631165L;

    protected AgrosystInterventionType agrosystInterventionType;

    protected List<RefInterventionAgrosystTravailEDI> interventionAgrosystTravailEDIs;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        if (agrosystInterventionType == null) {
            interventionAgrosystTravailEDIs = referentielService.getRefInterventionAgrosystTravailEDIs();
        } else {
            interventionAgrosystTravailEDIs = referentielService.getRefInterventionAgrosystTravailEDIs(agrosystInterventionType);
        }
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return interventionAgrosystTravailEDIs;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }
}
