package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadPricesIndicationJson.java 2120 2013-11-11 16:30:14Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/LoadPricesIndicationJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.common.ProductPrices;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadPricesIndicationJson extends AbstractJsonAction {

    private static final long serialVersionUID = -1437968191353986009L;

    protected PricesService pricesService;

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    /* Incomming parameters */
    protected String filter;
    protected String campaigns;
    protected String excludeZoneId;
    protected String excludePracticedSystemId;

    /* Outgoing parameters */
    protected ProductPrices prices;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setExcludeZoneId(String excludeZoneId) {
        this.excludeZoneId = excludeZoneId;
    }

    public void setExcludePracticedSystemId(String excludePracticedSystemId) {
        this.excludePracticedSystemId = excludePracticedSystemId;
    }

    @Override
    public String execute() throws Exception {
        Price priceFilter = getGson().fromJson(filter, Price.class);
        prices = pricesService.computePricesIndication(priceFilter, campaigns, excludeZoneId, excludePracticedSystemId);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return prices;
    }

}
