package fr.inra.agrosyst.web.actions.auth;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Logout.java 1451 2013-09-26 12:25:11Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/Logout.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import javax.servlet.http.HttpSession;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.web.AgrosystWebSession;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class Logout extends AbstractAgrosystAction {

    private static final long serialVersionUID = 3750812084600471474L;

    protected AuthenticationService authService;

    public void setAuthService(AuthenticationService authService) {
        this.authService = authService;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "namespace", "/", "actionName", "index" }) })
    public String execute() throws Exception {
        // logout on service
        String token = session.getAuthenticationToken();
        authService.logout(token);
        // Make sure token is removed
        session.setAuthenticationToken(null);
        // Then destroy the user's session object
        HttpSession httpSession = servletRequest.getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute(AgrosystWebSession.SESSION_PARAMETER);
        }
        return SUCCESS;
    }

}
