package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunImport.java 2100 2013-11-11 11:01:37Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunImport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.referentiels.RefAdventices;
import fr.inra.agrosyst.api.entities.referentiels.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referentiels.RefEspece;
import fr.inra.agrosyst.api.entities.referentiels.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiTypesEffluents;
import fr.inra.agrosyst.api.entities.referentiels.RefGesCarburants;
import fr.inra.agrosyst.api.entities.referentiels.RefGesEngrais;
import fr.inra.agrosyst.api.entities.referentiels.RefGesPhyto;
import fr.inra.agrosyst.api.entities.referentiels.RefGesSemences;
import fr.inra.agrosyst.api.entities.referentiels.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefMesure;
import fr.inra.agrosyst.api.entities.referentiels.RefNrjCarburants;
import fr.inra.agrosyst.api.entities.referentiels.RefNrjGesOutils;
import fr.inra.agrosyst.api.entities.referentiels.RefNrjPhyto;
import fr.inra.agrosyst.api.entities.referentiels.RefNrjSemences;
import fr.inra.agrosyst.api.entities.referentiels.RefNuisiblesEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefOTEX;
import fr.inra.agrosyst.api.entities.referentiels.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referentiels.RefSolCaracteristiquesIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referentiels.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referentiels.RefSupportOrganeEdi;
import fr.inra.agrosyst.api.entities.referentiels.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefUnitesEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referentiels.RefVarietePlantGrape;
import fr.inra.agrosyst.api.services.referentiels.ImportResult;
import fr.inra.agrosyst.api.services.referentiels.ImportService;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class RunImport extends AbstractAdminAction {

    private static final long serialVersionUID = 4130324772446717782L;

    protected ImportService importService;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    protected String genericClassName;
    protected Class<?> klass;

    protected File source1;
    protected File source2;
    protected File source3;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setSource1(File source1) {
        this.source1 = source1;
    }

    public void setSource2(File source2) {
        this.source2 = source2;
    }

    public void setSource3(File source3) {
        this.source3 = source3;
    }

    protected void required(File... sources) {
        if (sources != null) {
            int index = 0;
            for (File source : sources) {
                index++;
                if (source == null) {
                    addFieldError("source" + index, "Fichier manquant");
                }
            }
        }
    }

    @Override
    public void validate() {
        if (Strings.isNullOrEmpty(genericClassName)) {
            addFieldError("genericClassName", "Ce champ est obligatoire");
        }

        try {
            klass = Class.forName(genericClassName);
        } catch (ClassNotFoundException e) {
            addFieldError("genericClassName", "Classe non trouvée");
        }

        if (RefLocation.class.equals(klass)) {
            required(source1, source2, source3);
        } else if (RefSolArvalis.class.equals(klass)) {
            required(source1, source2);
        } else {
            required(source1);
        }

        super.validate();
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}"})})
    public String execute() throws Exception {
        checkIsAdmin();

        ImportResult importResult = null;

        if (RefSolArvalis.class.equals(klass)) {
            importResult = importService.importSolArvalisCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2));
        }

        if (RefLocation.class.equals(klass)) {
            importResult = importService.importCommuneInseeCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2),
                    new FileInputStream(source3));
        }

        if (RefMaterielTraction.class.equals(klass)) {
            importResult = importService.importMaterielTracteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielIrrigation.class.equals(klass)) {
            importResult = importService.importMaterielIrrigationCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielAutomoteur.class.equals(klass)) {
            importResult = importService.importMaterielAutomoteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielOutil.class.equals(klass)) {
            importResult = importService.importMaterielOutilsCSV(
                    new FileInputStream(source1));
        }

        if (RefLegalStatus.class.equals(klass)) {
            importResult = importService.importLegalStatusCSV(
                    new FileInputStream(source1));
        }

        if (RefEspece.class.equals(klass)) {
            importResult = importService.importEspeces(
                    new FileInputStream(source1));
        }

        if (RefVarieteGeves.class.equals(klass)) {
            importResult = importService.importVarietesGeves(
                    new FileInputStream(source1));
        }

        if (RefEspeceToVariete.class.equals(klass)) {
            importResult = importService.importEspecesToVarietes(
                    new FileInputStream(source1));
        }

        if (RefOTEX.class.equals(klass)) {
            importResult = importService.importOtexCSV(
                    new FileInputStream(source1));
        }

        if (RefClonePlantGrape.class.equals(klass)) {
            importResult = importService.importClonesPlantGrape(
                    new FileInputStream(source1));
        }

        if (RefVarietePlantGrape.class.equals(klass)) {
            importResult = importService.importVarietesPlantGrape(
                    new FileInputStream(source1));
        }

        if (RefOrientationEDI.class.equals(klass)) {
            importResult = importService.importOrientationEdiCSV(
                    new FileInputStream(source1));
        }
        
        if (RefSolTextureGeppa.class.equals(klass)) {
            importResult = importService.importSolTextureGeppa(
                    new FileInputStream(source1));
        }
        
        if (RefParcelleZonageEDI.class.equals(klass)) {
            importResult = importService.importZonageParcelleEdi(
                    new FileInputStream(source1));
        }
        
        if (RefSolProfondeurIndigo.class.equals(klass)) {
            importResult = importService.importSolProfondeurIndigo(
                    new FileInputStream(source1));
        }

        if (RefSolCaracteristiquesIndigo.class.equals(klass)) {
            importResult = importService.importSolCarateristiquesIndigo(
                    new FileInputStream(source1));
        }
        
        if (RefAdventices.class.equals(klass)) {
            importResult = importService.importAdventices(
                    new FileInputStream(source1));
        }
        
        if (RefNuisiblesEDI.class.equals(klass)) {
            importResult = importService.importNuisiblesEDI(
                    new FileInputStream(source1));
        }
        
        if (RefFertiMinUNIFA.class.equals(klass)) {
            importResult = importService.importFertiMinUNIFA(new FileInputStream(source1));
        }
        
        if (RefFertiTypesEffluents.class.equals(klass)) {
            importResult = importService.importFertiTypesEffluents(new FileInputStream(source1));
        }
        
        if (RefTypeTravailEDI.class.equals(klass)) {
            importResult = importService.importTypeTravailEdiCSV(new FileInputStream(source1));
        }
        
        if (RefInterventionAgrosystTravailEDI.class.equals(klass)) {
            importResult = importService.importInterventionAgrosystTravailEdiCSV(new FileInputStream(source1));
        }
        
        if (RefStadeEDI.class.equals(klass)) {
            importResult = importService.importStadesEdiCSV(new FileInputStream(source1));
        }
        
        if (RefUnitesEDI.class.equals(klass)) {
            importResult = importService.importUnitesEdi(new FileInputStream(source1));
        }
        
        if (RefStationMeteo.class.equals(klass)) {
            importResult = importService.importStationMeteo(new FileInputStream(source1));
        }
        
        if (RefGesCarburants.class.equals(klass)) {
            importResult = importService.importGesCarburants(new FileInputStream(source1));
        }
        if (RefGesEngrais.class.equals(klass)) {
            importResult = importService.importGesEngrais(new FileInputStream(source1));
        }
        if (RefGesPhyto.class.equals(klass)) {
            importResult = importService.importGesPhyto(new FileInputStream(source1));
        }
        if (RefGesSemences.class.equals(klass)) {
            importResult = importService.importGesSemences(new FileInputStream(source1));
        }
        if (RefNrjCarburants.class.equals(klass)) {
            importResult = importService.importNrjCarburants(new FileInputStream(source1));
        }
        if (RefNrjPhyto.class.equals(klass)) {
            importResult = importService.importNrjPhyto(new FileInputStream(source1));
        }
        if (RefNrjSemences.class.equals(klass)) {
            importResult = importService.importNrjSemences(new FileInputStream(source1));
        }
        if (RefNrjGesOutils.class.equals(klass)) {
            importResult = importService.importNrjGesOutils(new FileInputStream(source1));
        }
        if (RefMesure.class.equals(klass)) {
            importResult = importService.importMesure(new FileInputStream(source1));
        }
        if (RefSupportOrganeEdi.class.equals(klass)) {
            importResult = importService.importSupportOrganeEdi(new FileInputStream(source1));
        }

        if (importResult != null) {
            if (importResult.hasErrors()) {
                for (String error : importResult.getErrors()) {
                    notificationSupport.importError("ÉCHEC : %s", error);
                }
            } else {
                notificationSupport.importSuccess("RÉUSSITE : Import terminé en %dms. %d créé(s) - %d modifié(s) - %d supprimé(s) - %d ignoré(s)",
                        importResult.getDuration(),
                        importResult.getCreated(),
                        importResult.getUpdated(),
                        importResult.getDeleted(),
                        importResult.getIgnored());
            }
        }
        return SUCCESS;
    }

}
