/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebNotificationSupport.java 2030 2013-11-06 16:33:46Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebNotificationSupport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import fr.inra.agrosyst.api.entities.DecisionRule;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.ManagementMode;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.Performance;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PracticedSystem;
import fr.inra.agrosyst.api.services.users.UserDto;

public class AgrosystWebNotificationSupport {

    protected AgrosystWebSession agrosystSession;

    public AgrosystWebNotificationSupport(AgrosystWebSession agrosystSession) {
        this.agrosystSession = agrosystSession;
    }

    public void domainSaved(Domain domain) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Domaine '%s' enregistré", domain.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void domainExtendError(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message);
        agrosystSession.getErrorNotifications().add(msg);
    }

    public void growingPlanSaved(GrowingPlan growingPlan) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Dispositif '%s' enregistré", growingPlan.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void growingSystemSaved(GrowingSystem growingSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Système de culture '%s' enregistré", growingSystem.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void importError(String message, String error) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, error);
        agrosystSession.getErrorNotifications().add(msg);
    }

    public void importSuccess(String message, long duration, int created, int updated, int deleted, int ignored) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, duration, created, updated, deleted, ignored);
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void practicedSystemSaved(PracticedSystem practicedSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Système pratiqué '%s' enregistré", practicedSystem.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void networkSaved(Network network) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Réseau '%s' enregistré", network.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void plotSaved(Plot plot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Parcelle '%s' enregistrée", plot.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void userSaved(UserDto user) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Utilisateur '%s %s' enregistré", user.getLastName(), user.getFirstName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void decisionRuleSaved(DecisionRule decisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Règle de décision '%s' enregistrée", decisionRule.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void managementModeSaved(ManagementMode managementMode) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Mode de gestion enregistré");
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void culturalInterventionCreated() {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Interventions culturales enregistrées");
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void performanceSaved(Performance performance) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Performance enregistrée");
        agrosystSession.getInfoNotifications().add(msg);
    }

    protected void notWritable(String entityType, String pronom) {
        String message = String.format("Vous n'avez pas les droits nécessaires pour modifier %s %s", pronom, entityType);
        AgrosystWebNotification msg = AgrosystWebNotification.of(message);
        agrosystSession.getWarningNotifications().add(msg);
    }

    protected void notWritable(String entityType) {
        notWritable(entityType, "ce");
    }

    public void domainNotWritable() {
        notWritable("domaine");
    }

    public void growingPlanNotWritable() {
        notWritable("dispositif");
    }

    public void growingSystemNotWritable() {
        notWritable("système de culture");
    }

    public void networkNotWritable() {
        notWritable("réseau");
    }

    public void practicedSystemNotWritable() {
        notWritable("système pratiqué");
    }

    public void managementModeNotWritable() {
        notWritable("mode de gestion");
    }

    public void decisionRuleNotWritable() {
        notWritable("règle de décision", "cette");
    }

    public void effectiveCropCyclesNotWritable() {
        notWritable("cycles réalisés", "ces");
    }
}
