/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebNotification.java 1725 2013-10-18 17:17:36Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.7.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebNotification.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import com.google.common.collect.ImmutableMap;

public class AgrosystWebNotification {

    protected String text;

    protected AgrosystWebNotificationLink link;

    public AgrosystWebNotification(String text) {
        this.text = text;
    }

    public static AgrosystWebNotification of(String text, Object... args) {
        return new AgrosystWebNotification(String.format(text, args));
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public AgrosystWebNotificationLink getLink() {
        return link;
    }

    public void setLink(AgrosystWebNotificationLink link) {
        this.link = link;
    }

    public AgrosystWebNotification link(String label, String namespace, String action, String k1, String v1) {
        this.link = new AgrosystWebNotificationLink(label,namespace ,action, ImmutableMap.of(k1, v1));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AgrosystWebNotification that = (AgrosystWebNotification) o;

        if (link != null ? !link.equals(that.link) : that.link != null) return false;
        if (text != null ? !text.equals(that.text) : that.text != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = text != null ? text.hashCode() : 0;
        result = 31 * result + (link != null ? link.hashCode() : 0);
        return result;
    }

}
