package fr.inra.agrosyst.web.actions.species;

import java.util.List;

import fr.inra.agrosyst.api.entities.referentiels.RefEspece;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListSpeciesJson.java 1213 2013-09-08 09:19:05Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/species/ListSpeciesJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

public class ListSpeciesJson extends AbstractJsonAction {

    private static final long serialVersionUID = 5088194867807225637L;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected List<RefEspece> species;

    protected String term;

    public void setTerm(String term) {
        this.term = term;
    }

    @Override
    public String execute() {
        species = referentielService.findSpecies(term);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return species;
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }

}
