/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsList.java 828 2013-08-06 13:39:32Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.practiced;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.PracticedSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PracticedSystemsList extends AbstractAgrosystAction {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 3084229660685255829L;

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    /**
     * Initial list data.
     */
    protected ResultList<PracticedSystem> practicedSystems;

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        PracticedSystemFilter filter = new PracticedSystemFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        practicedSystems = practicedSystemService.getFilteredPracticedSystems(filter);
        return SUCCESS;
    }

    public ResultList<PracticedSystem> getPracticedSystems() {
        return practicedSystems;
    }
}
