/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsEditJson.java 1345 2013-09-16 13:08:11Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.practiced;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.struts2.convention.annotation.Action;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Actions json utilisées par l'action {@link PracticedSystemsEditJson}.
 * 
 * Action supportée:
 * - rechargement au changement 'system de culture' et/ou 'campagne'
 * 
 * @author Eric Chatellier
 */
public class PracticedSystemsEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4385936088893971371L;

    protected PracticedSystemService practicedSystemService;

    protected String growingSystemId;

    protected String campaigns;

    protected Object jsonData;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    @Action("practiced-systems-crops-tools-json")
    public String execute() {

        Map<String, Object> data = Maps.newHashMap();

        // chargement des toutes les cultures pour les systems de cultures et les années
        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> modelToSpecies =
                practicedSystemService.getCropCycleModelMap(growingSystemId, campaigns, true);
        Set<CropCycleModelDto> croppingPlanEntryDtos = modelToSpecies.keySet();

        // definition de la liste de culture principale
        Iterable<CropCycleModelDto> modelMain = Iterables.filter(croppingPlanEntryDtos, CroppingPlans.IS_NOT_INTERMEDIATE);
        data.put("practicedSystemMainCropCycleModels", Lists.newArrayList(modelMain)); // force no lazy

        // définition de la liste de culture intermédiaire
        Iterable<CropCycleModelDto> modelIntermediate = Iterables.filter(croppingPlanEntryDtos, CroppingPlans.IS_INTERMEDIATE);
        data.put("practicedSystemIntermediateCropCycleModels", Lists.newArrayList(modelIntermediate)); // force no lazy

        // chargement de la map 'code culture' > liste d'espece
        Map<String, List<CroppingPlanSpeciesDto>> growingSystemsCodeToSpecies = Maps.newHashMap();
        for (Map.Entry<CropCycleModelDto, List<CroppingPlanSpeciesDto>> entry : modelToSpecies.entrySet()) {
            growingSystemsCodeToSpecies.put(entry.getKey().getCroppingPlanEntryCode(), entry.getValue());
        }
        data.put("practicedSystemCroppingEntryPlanToSpecies", growingSystemsCodeToSpecies);

        // chargement des toolsCouplings
        List<ToolsCouplingDto> toolsCouplingsDtos = practicedSystemService.getToolsCouplingModel(growingSystemId, campaigns);
        data.put("practicedSystemToolsCouplings", Lists.newArrayList(toolsCouplingsDtos)); // force no lazy
        
        jsonData = data;
        return SUCCESS;
    }
    
    public Object getJsonData() {
        return jsonData;
    }
}
