package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefMinUnifaShapesJson.java 1469 2013-09-30 16:08:19Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefMinUnifaShapesJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadRefMinUnifaShapesJson extends AbstractJsonAction {

    private static final long serialVersionUID = -5676283869376045776L;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected List<String> fertilizerShape;

    protected Integer categ;

    @Override
    public String execute() throws Exception {
        fertilizerShape = referentielService.findAllActiveFertiMinShape(categ);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return fertilizerShape;
    }

    public void setCateg(Integer categ) {
        this.categ = categ;
    }

}
