package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadProductPricesJson.java 1792 2013-10-22 08:39:45Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadProductPricesJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.practiced.ProductPrices;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadProductPricesJson extends AbstractJsonAction {

    private static final long serialVersionUID = -2051822874070203733L;

    protected String campaigns;

    protected String refFertiMinUnifaTopiaId;

    protected String refFertiEngraiorgTopiaId;

    protected String refTypeProduitActaTopiaId;

    protected List<String> speciesCodes;

    protected ReferentielService referentielService;

    protected ProductPrices productPrices;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    @Override
    public String execute() throws Exception {
        String allCampains = null;
        if (this.campaigns != null && practicedSystemService.areCampaignsValid(this.campaigns)){
            allCampains = this.campaigns;
        }
        if (!Strings.isNullOrEmpty(refFertiMinUnifaTopiaId)){
            productPrices = referentielService.getFertiMinProductPrices(refFertiMinUnifaTopiaId, allCampains);
        }

        if (!Strings.isNullOrEmpty(refFertiEngraiorgTopiaId)){
            productPrices = referentielService.getFertiEngraisorgProductPrices(refFertiEngraiorgTopiaId, allCampains);
        }

        if (!Strings.isNullOrEmpty(refTypeProduitActaTopiaId)){
            //TODO david 16/10/2013 manque le référentiel (pour les actions de type semis)
        }

        if (speciesCodes != null && !speciesCodes.isEmpty()) {
            productPrices = practicedSystemService.getSeedsSpeciesPrices(speciesCodes, allCampains);
        }

        if (productPrices.getAllCampaignsProductPriceSummary() == null && productPrices.getCurrentCampaignsProductPriceSummary() == null) {
            productPrices = null;
        }

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return productPrices;
    }


    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setRefFertiMinUnifaTopiaId(String refFertiMinUnifaTopiaId) {
        this.refFertiMinUnifaTopiaId = refFertiMinUnifaTopiaId;
    }

    public void setRefFertiEngraiorgTopiaId(String refFertiEngraiorgTopiaId) {
        this.refFertiEngraiorgTopiaId = refFertiEngraiorgTopiaId;
    }

    public void setRefTypeProduitActaTopiaId(String refTypeProduitActaTopiaId) {
        this.refTypeProduitActaTopiaId = refTypeProduitActaTopiaId;
    }

    public void setSpeciesCodes(List<String> speciesCodes) {
        this.speciesCodes = speciesCodes;
    }
}
