package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: SearchNetworkJson.java 1916 2013-10-28 16:52:52Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/SearchNetworkJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.LinkedHashMap;
import java.util.Set;

import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class SearchNetworkJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4654758167246992232L;

    protected NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected String term;
    protected Set<String> exclusions;

    protected LinkedHashMap<String, String> networks;

    public void setTerm(String term) {
        this.term = term;
    }

    public void setExclusions(Set<String> exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public String execute() {
        //TODO david, 07/08/2013 add a parameter for the number of expecting result
        networks = networkService.getNameFilteredActiveNetworks(term, 10, exclusions);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return networks;
    }

}
