package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListUserJson.java 1822 2013-10-22 14:48:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/ListUserJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class ListUserJson extends AbstractJsonAction {

    private static final long serialVersionUID = -7522268674597633447L;

    protected UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected String term;

    protected List<UserDto> users;

    @Override
    public String execute() {
        //TODO david, 07/08/2013 add a parameter for the number of expecting result
        users = userService.getNameFilteredActiveUsers(term, null);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return users;
    }

    public void setTerm(String term) {
        this.term = term;
    }

}
